/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.regionalsettings;

import java.util.List;
import javax.annotation.Nonnull;

public class StrftimePatternConverter {
    private static final List<ConversionPattern> javaToStrFtime = List.of(new ConversionPattern("EEEEE", "%A", "__1__"), new ConversionPattern("EEE", "%a", "__2__"), new ConversionPattern("MMMMM", "%B", "__3__"), new ConversionPattern("MMM", "%b", "__4__"), new ConversionPattern("MM", "%m", "__5__"), new ConversionPattern("dd", "%d", "__6__"), new ConversionPattern("d", "%e", "__7__"), new ConversionPattern("HH", "%H", "__8__"), new ConversionPattern("hh", "%I", "__9__"), new ConversionPattern("D", "%j", "__10__"), new ConversionPattern("mm", "%M", "__11__"), new ConversionPattern("SSS", "%L", "__12__"), new ConversionPattern("ss", "%S", "__13__"), new ConversionPattern("a", "%p", "__14__"), new ConversionPattern("w", "%W", "__15__"), new ConversionPattern("yyyy", "%Y", "__16__"), new ConversionPattern("yy", "%y", "__17__"));

    @Nonnull
    public static String javaToStrftime(@Nonnull String javaPattern) {
        String strFtimePattern = javaPattern;
        for (ConversionPattern p : javaToStrFtime) {
            strFtimePattern = strFtimePattern.replaceAll(p.javaSymbol() + "(?=(?:[^']*'[^']*')*[^']*$)", p.tempSymbol());
        }
        for (ConversionPattern p : javaToStrFtime) {
            strFtimePattern = strFtimePattern.replaceAll(p.tempSymbol(), p.strftimeSymbol());
        }
        return strFtimePattern;
    }

    @Nonnull
    public static String strftimeToJava(@Nonnull String strFtimePattern) {
        String javaPattern = strFtimePattern;
        for (ConversionPattern p : javaToStrFtime) {
            javaPattern = javaPattern.replaceAll(p.strftimeSymbol() + "(?=(?:[^']*'[^']*')*[^']*$)", p.javaSymbol());
        }
        return javaPattern;
    }

    private record ConversionPattern(String javaSymbol, String strftimeSymbol, String tempSymbol) {
    }
}

